/****************************************************************************
*                                                                           *
* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY     *
* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE       *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR     *
* PURPOSE.                                                                  *
*                                                                           *
* Copyright(C) 1997-98 by PSH //UCL.                                        *
*                                                                           *
*****************************************************************************
*                                                                           *
* This is File I/O functions for Demo Version of Soft-Pro HASP Emulator     *
*                                                                           *
****************************************************************************/

#include "..\common\emuver.h"
#include "..\common\hasp-emu.h"

// If for Win95

#ifdef HASP_EMU_95
#include <basedef.h>
#include <vmm.h>

#pragma VxD_LOCKED_CODE_SEG
#pragma VxD_LOCKED_DATA_SEG

#endif

/****************************************************************************
* Create or Open File                                                       *
*****************************************************************************
* Params: file - filename                                                   *
*         mode - create or open                                             *
*****************************************************************************
* Return: int - handle                                                      *
****************************************************************************/
int EMUCreateFile(char *file,int mode)
{

// In Demo Version Only 1 Key Supported

if (EMUMemNCmp(file,PASSWORDS_ID,8)==0)
	return 1;
return -1;
}

/****************************************************************************
* Close File                                                                *
*****************************************************************************
* Params: handle - file handle                                              *
*****************************************************************************
* Return: int - status (0 - OK)                                             *
****************************************************************************/
int EMUCloseFile(int handle)
{
// Always success
return 0;
}

/****************************************************************************
* Write File                                                                *
*****************************************************************************
* Params: handle - file handle                                              *
*         size   - num. bytes to write                                      *
*         pos    - offset in file                                           *
*         buffer - buffer                                                   *
*****************************************************************************
* Return: int - bytes writed or -1 if error                                 *
****************************************************************************/
int EMUWriteFile(int handle,int size,int pos,unsigned char *buffer)
{
// Always success
return size;
}

/****************************************************************************
* Read File                                                                 *
*****************************************************************************
* Params: handle - file handle                                              *
*         size   - num. bytes to reade                                      *
*         pos    - offset in file                                           *
*         buffer - buffer                                                   *
*****************************************************************************
* Return: int - bytes readed or -1 if error                                 *
****************************************************************************/
int EMUReadFile(int handle,int size,int pos,unsigned char *buffer)
{
char *buf=DEMO_DUMP_BUFFER;
buf=buf+pos;
if ((pos+size)>DEMO_DUMP_SIZE)
	return -1;
EMUMemCpy(buffer,buf,size);
return size;
}
